<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.min.css">
        <style>
            .demo {
                background-color: rgb(11, 156, 11);
                margin-left: 10px;
                margin-right: 10px;
                padding: 10px;
                font-size: 20px;
                font-weight: bold;
                color: white;
                border-radius: 5px;
            }
        </style>
    </x-slot:head>


    <section class="content">

        <!-- Default box -->
        <div class="row">
            <div class="col-lg-12">
                <x-message></x-message>
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <button class="btn btn-success float-right mb-3" data-toggle="modal" data-target="#tambah"><i
                                class="fa fa-plus-circle mr-2"></i> Diskon
                            Baru</button>
                        <h3 class="card-title"><i class="fa fa-server text-primary"></i> {{ $data['page'] }}</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-hover myTable tab">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th>Judul</th>
                                    <th>Disc</th>
                                    <th>Mulai Tanggal</th>
                                    <th>Sampai Tanggal</th>
                                    <th>Timer</th>
                                    <th>Status</th>
                                    <th width="15%">Opsi</th>
                                </tr>
                            </thead>
                            <tbody id="view">
                                @forelse ($modul as $d)
                                    <tr>
                                        <td class="text-center">{{ $no++ }}</td>
                                        <td>{{ $d->judul }}</td>
                                        <td class="text-center">{{ $d->isi }}%</td>
                                        <td>{{ tgl_time($d->tgl1) }}</td>
                                        <td>{{ tgl_time($d->tgl2) }}</td>
                                        <td class="text-center">
                                            @if ($d->status == 'Y')
                                                <input type="hidden" name="" id="tgl"
                                                    value="{{ $d->tgl2 }}">
                                                <div class="demo" id="demo"></div>
                                            @else
                                                EXPIRED
                                            @endif
                                        </td>
                                        <td>
                                            <div class="custom-control custom-switch   custom-switch-on-success">
                                                <input type="checkbox" class="custom-control-input check"
                                                    data-id="{{ $d->id }}" data-v="{{ $d->status }}"
                                                    {{ $d->status == 'Y' ? 'checked' : '' }}
                                                    id="status{{ $d->id }}">
                                                <label class="custom-control-label" for="status{{ $d->id }}">
                                                    {{ $d->status == 'Y' ? 'Aktif' : 'Tidak Aktif' }}</label>
                                            </div>

                                        </td>
                                        <td class="text-center">
                                            <button class="btn btn-primary btn-sm" data-toggle="modal"
                                                data-target="#edit{{ $d->id }}"><i class="fa fa-edit mr-2"></i>
                                                Edit</button>
                                            <button class="btn btn-danger btn-sm hapus" data-id="{{ $d->id }}"
                                                data-nm="{{ $d->judul }}"><i class="fa fa-trash mr-2"></i>
                                                Hapus</button>
                                        </td>
                                    </tr>


                                @empty
                                    <tr>
                                        <td colspan="12" class="text-center">Data masih kosong</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            {{-- <p id="demo">sa</p> --}}

        </div>
        <!-- /.card -->

    </section>


    {{-- tambah Banner --}}
    <div class="modal fade" id="tambah">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-primary ">
                    Tambah Diskon
                </div>
                <form action="{{ route('diskon.tambah') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Judul Diskon</label>
                            <input type="text" name="judul_diskon" class="form-control" placeholder="Judul Diskon"
                                autofocus required value="{{ old('judul_diskon') }}">
                        </div>
                        <div class="form-group">
                            <label>Jumlah Diskon</label>
                            <input type="text" name="diskon" class="form-control numbers" placeholder="0%" required
                                value="{{ old('diskon') }}">
                        </div>
                        <div class="form-group">
                            <label>Mulai Tanggal</label>
                            <input type="date" name="tgl1" class="form-control" required
                                value="{{ date('Y-m-d') }}">
                        </div>
                        <div class="form-group">
                            <label>Sampai Tanggal</label>
                            <input type="date" name="tgl2" class="form-control" required
                                value="{{ date('Y-m-d') }}">
                        </div>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary satuan"><i class="fa fa-save mr-2"></i>
                            Simpan</button>
                    </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    @foreach ($modul as $d)
        <div class="modal fade" id="edit{{ $d->id }}">
            <div class="modal-dialog ">
                <div class="modal-content">
                    <div class="modal-header bg-primary ">
                        Tambah Diskon
                    </div>
                    <form action="{{ route('diskon.edit') }}" method="post">
                        @csrf
                        <input type="hidden" name="id" id="" value="{{ $d->id }}">
                        <div class="modal-body">
                            <div class="form-group">
                                <label>Judul Diskon</label>
                                <input type="text" name="judul_diskon" class="form-control"
                                    placeholder="Judul Diskon" autofocus required value="{{ $d->judul }}">
                            </div>
                            <div class="form-group">
                                <label>Jumlah Diskon</label>
                                <input type="text" name="diskon" class="form-control numbers" placeholder="0%"
                                    required value="{{ $d->isi }}">
                            </div>
                            <div class="form-group">
                                <label>Mulai Tanggal</label>
                                <input type="date" name="tgl1" class="form-control" required
                                    value="{{ date('Y-m-d', strtotime($d->tgl1)) }}">
                            </div>
                            <div class="form-group">
                                <label>Sampai Tanggal</label>
                                <input type="date" name="tgl2" class="form-control" required
                                    value="{{ date('Y-m-d', strtotime($d->tgl2)) }}">
                            </div>
                        </div>
                        <div class="modal-footer justify-content-between">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary satuan"><i class="fa fa-save mr-2"></i>
                                Simpan</button>
                        </div>
                    </form>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
    @endforeach


    <x-slot:foot>
        <script src="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script>
            $(function() {
                $('.myTable').DataTable();
            });


            $('#view').on('click', '.check', function() {
                var token = $("meta[name='csrf-token']").attr("content");
                var id = $(this).attr('data-id');
                var value = $(this).attr('data-v');
                if (value == "Y") {
                    var isi = "N";
                } else {
                    var isi = "Y";
                }
                $.ajax({
                    type: 'POST',
                    url: 'status-diskon',
                    data: {
                        id: id,
                        isi: isi,
                        _token: token,
                    },
                    success: function(data) {
                        document.location.href = "";
                    }
                });
            });

            $('#view').on('click', '.hapus', function() {
                var id = $(this).attr('data-id');
                var nama = $(this).attr('data-nm');

                Swal.fire({
                    title: "Apa anda yakin?",
                    text: "Diskon dengan Judul ( " + nama + " ) akan di hapus!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Ya, Hapus!"
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.location.href = "delete-diskon/" + id;
                    }
                });

            });
        </script>
        <script>
            // Set the date we're counting down to
            // var id = {{ $d->id }};
            var tgl = $('#tgl').val();
            var countDownDate = new Date(tgl).getTime();

            // Update the count down every 1 second
            var x = setInterval(function() {

                // Get today's date and time
                var now = new Date().getTime();

                // Find the distance between now and the count down date
                var distance = countDownDate - now;

                // Time calculations for days, hours, minutes and seconds
                var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((distance % (1000 * 60)) / 1000);

                // Output the result in an element with id="demo"
                document.getElementById("demo").innerHTML = days + " Hari " + hours + " : " +
                    minutes + " : " + seconds + "  ";

                // If the count down is over, write some text 
                if (distance < 0) {
                    clearInterval(x);
                    document.getElementById("demo").innerHTML = "EXPIRED";
                }
            }, 1000);
        </script>
    </x-slot:foot>
</x-admin.contents>
